﻿using System;

namespace Sf.Blazor.Dashboard.Example.ViewModels
{
    public class DashLayoutViewModel : NotifyPropertyChangedBase
    {
        private DashLayoutPositionViewModel _position;
        private DashLayoutSizeViewModel _size;

        public DashLayoutViewModel()
        {
            Id = Guid.NewGuid();
        }

        public Guid Id { get; }

        public DashLayoutPositionViewModel Position
        {
            get => _position;
            set => Set(ref _position, value);
        }

        public DashLayoutSizeViewModel Size
        {
            get => _size;
            set => Set(ref _size, value);
        }

        public string Value { get; set; }
    }
}